package gov.va.med.mhv.sm.admin.model;


import gov.va.med.mhv.sm.admin.enums.ClinicalUserTypeEnum;
import gov.va.med.mhv.sm.admin.enums.ParticipantTypeEnum;
import gov.va.med.mhv.sm.admin.enums.UserTypeEnum;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Entity
@DiscriminatorValue("1")
public class Clinician extends SMUser {

	private static final long serialVersionUID = 3L;

	public Clinician(){
		super();
		this.userType = UserTypeEnum.CLINICIAN;
		this.participantType = ParticipantTypeEnum.CLINICIAN;
	}
	
	@Column(name = "CLINICAL_USER_TYPE_ID")
	private Long clinicalUserType;

	@Column(name = "DUZ")
	private String duz;

	@Column(name = "PROVIDER_DMMS_UNITS")
	private String dmmsUnits;
	
	@Column(name = "PROVIDER_PERSON_CLASS")
	private String personClass;
	
	@Column(name = "PROVIDER")
	private String provider;
	
	@Column(name = "PROVIDER_CLASS")
	private String providerClass;
	
	@Column(name = "PROVIDER_PCMM_FLAG")
	private String providerPcmmFlag;
	
	@Column(name = "PROVIDER_VISTA_ACTIVE_FLAG")
	private String providerVistAActiveFlag;
	
	@Column(name = "PROVIDER_REQUIRES_COSIGNER")
	private String requiresCosigner;
	
	@Column(name = "STATION_NO")
	private String stationNo;

	public Long getClinicalUserType() {
		return clinicalUserType;
	}

	public void setClinicalUserType(Long clinicalUserType) {
		this.clinicalUserType = clinicalUserType;
	}

	public String getDuz() {
		return duz;
	}

	public void setDuz(String duz) {
		this.duz = duz;
	}

	public String getDmmsUnits() {
		return dmmsUnits;
	}

	public void setDmmsUnits(String dmmsUnits) {
		this.dmmsUnits = dmmsUnits;
	}

	public String getPersonClass() {
		return personClass;
	}

	public void setPersonClass(String personClass) {
		this.personClass = personClass;
	}

	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getProviderClass() {
		return providerClass;
	}

	public void setProviderClass(String providerClass) {
		this.providerClass = providerClass;
	}

	public String getProviderPcmmFlag() {
		return providerPcmmFlag;
	}

	public void setProviderPcmmFlag(String providerPcmmFlag) {
		this.providerPcmmFlag = providerPcmmFlag;
	}

	public String getProviderVistAActiveFlag() {
		return providerVistAActiveFlag;
	}

	public void setProviderVistAActiveFlag(String providerVistAActiveFlag) {
		this.providerVistAActiveFlag = providerVistAActiveFlag;
	}

	public String getRequiresCosigner() {
		return requiresCosigner;
	}

	public void setRequiresCosigner(String requiresCosigner) {
		this.requiresCosigner = requiresCosigner;
	}

	public String getStationNo() {
		return stationNo;
	}

	public void setStationNo(String stationNo) {
		this.stationNo = stationNo;
	}
		
	
}
